/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.task.service.impl;

import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.scheduler.AutoBackupSchedule;
import com.tp_link.eap.domain.scheduler.RebootSchedule;
import com.tp_link.eap.domain.scheduler.Schedule;
import com.tp_link.eap.domain.scheduler.bean.HMS;
import com.tp_link.eap.domain.scheduler.bean.ScheduleTime;
import com.tp_link.eap.domain.scheduler.bean.TaskType;
import com.tp_link.eap.domain.scheduler.bean.TimingType;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.task.b;
import com.tp_link.eap.monitor.task.c;
import com.tp_link.eap.monitor.task.repo.ScheduleRepository;
import com.tp_link.eap.monitor.task.service.a;
import com.tp_link.eap.monitor.task.service.impl.TaskManager;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="scheduleService")
public class ScheduleService
extends com.tp_link.eap.i.a.a<Schedule>
implements a {
    @Autowired
    private ScheduleRepository a;
    @Autowired
    private TaskManager b;
    @Autowired
    private Validator validator;
    @Autowired
    private com.tp_link.eap.monitor.cloudkey.service.a c;
    private static final Logger d = LoggerFactory.getLogger(ScheduleService.class);
    private static final String e = TaskType.Reboot.name();
    private static final String f = TaskType.AutoBackup.name();

    public List<Schedule> getList(QueryPage queryPage) {
        return this.getList(queryPage, null);
    }

    public List<Schedule> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<Schedule> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<Schedule> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    @Override
    public List<Schedule> getEnableSchedules() {
        return this.a.findByEnable(true);
    }

    @Override
    public OperationResponse addSchedule(Schedule schedule) {
        if (schedule == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        schedule.setSite(com.tp_link.eap.d.b.a());
        schedule.setScheduleCron(com.tp_link.eap.monitor.task.b.a.a(schedule.getScheduleTime()));
        schedule.setNextExecute(com.tp_link.eap.monitor.task.b.a.b(schedule.getScheduleTime()));
        Schedule schedule2 = (Schedule)this.a.save(schedule);
        if (schedule.isEnable()) {
            this.a(schedule2);
        }
        return new OperationResponse(ResErrorCode.a, (Object)schedule2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse refreshSchedule(Schedule schedule) {
        Object object;
        if (schedule == null) {
            d.debug("Schedule is null");
            return new OperationResponse(ResErrorCode.d);
        }
        if (schedule.getSite() == null && e.equals(schedule.getScheduleType())) {
            schedule.setSite(com.tp_link.eap.d.b.a());
        }
        Object object2 = object = com.tp_link.eap.monitor.task.a.b.a(schedule.getScheduleId());
        synchronized (object2) {
            Schedule schedule2 = (Schedule)this.a.findOne((Serializable)((Object)schedule.getScheduleId()));
            String string = com.tp_link.eap.monitor.task.b.a.a(schedule.getScheduleTime());
            if (schedule2.getScheduleCron().equals(string)) {
                schedule.setScheduleCron(string);
                schedule.setNextExecute(schedule2.getNextExecute());
                this.a.save(schedule);
                if (!schedule.isEnable() && schedule2.isEnable()) {
                    this.b.a(schedule.getScheduleId());
                }
                if (schedule.isEnable() && !schedule2.isEnable()) {
                    this.a(schedule);
                }
            } else {
                schedule.setScheduleCron(string);
                schedule.setNextExecute(com.tp_link.eap.monitor.task.b.a.b(schedule.getScheduleTime()));
                this.a.save(schedule);
                this.b.a(schedule.getScheduleId());
                if (schedule.isEnable()) {
                    this.a(schedule);
                }
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult deleteSchedule(String scheduleId) {
        Object object;
        if (scheduleId == null) {
            return com.tp_link.eap.util.e.aX;
        }
        Object object2 = object = com.tp_link.eap.monitor.task.a.b.a(scheduleId);
        synchronized (object2) {
            Schedule schedule = (Schedule)this.a.findOne((Serializable)((Object)scheduleId));
            if (schedule == null) {
                return new OperationResult(false, "Task to be deleted is not exist.");
            }
            this.a.delete(schedule);
            this.b.a(scheduleId);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult enableSchedule(String scheduleId) {
        Object object;
        if (scheduleId == null) {
            return com.tp_link.eap.util.e.aX;
        }
        Object object2 = object = com.tp_link.eap.monitor.task.a.b.a(scheduleId);
        synchronized (object2) {
            Schedule schedule = (Schedule)this.a.findOne((Serializable)((Object)scheduleId));
            if (schedule == null) {
                return new OperationResult(false, "Task to be enabled is not exist.");
            }
            if (schedule.isEnable()) {
                return new OperationResult(false, "Task " + schedule.getScheduleName() + " is alreadly enabled.");
            }
            schedule.setNextExecute(com.tp_link.eap.monitor.task.b.a.b(schedule.getScheduleTime()));
            this.a.save(schedule);
            this.a(schedule);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult disableSchedule(String scheduleId) {
        Object object;
        if (scheduleId == null) {
            return com.tp_link.eap.util.e.aX;
        }
        Object object2 = object = com.tp_link.eap.monitor.task.a.b.a(scheduleId);
        synchronized (object2) {
            Schedule schedule = (Schedule)this.a.findOne((Serializable)((Object)scheduleId));
            if (schedule == null) {
                return new OperationResult(false, "Task to be disabled is not exist.");
            }
            if (!schedule.isEnable()) {
                return new OperationResult(false, "Task " + schedule.getScheduleName() + " is alreadly disabled.");
            }
            this.b.a(scheduleId);
        }
        return com.tp_link.eap.util.e.bc;
    }

    private void a(Schedule schedule) {
        b b2 = com.tp_link.eap.monitor.task.c.a(schedule);
        if (b2 != null) {
            this.b.a(b2);
        }
    }

    @Override
    public Schedule getSchedule(String scheduleId) {
        return (Schedule)this.a.findOne((Serializable)((Object)scheduleId));
    }

    @Override
    public List<Schedule> getAllSchedules() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
    }

    @Override
    public void deletAllSchedules() {
        List<Schedule> list = this.getAllSchedules();
        if (!CollectionUtils.isEmpty(list)) {
            for (Schedule schedule : list) {
                this.deleteSchedule(schedule.getScheduleId());
            }
        }
    }

    @Override
    public void deleteBySite() {
        List<Schedule> list = this.a.findBySite(com.tp_link.eap.d.b.a());
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getRebootSchedule(ControlType controlType, JSONObject reqObj) {
        Object object = com.tp_link.eap.b.b.a.l((String)com.tp_link.eap.d.b.a());
        synchronized (object) {
            Schedule schedule = this.a();
            return new OperationResponse(ResErrorCode.a, (Object)schedule);
        }
    }

    @Override
    @Deprecated
    public OperationResponse addRebootSchedule(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        RebootSchedule rebootSchedule = (RebootSchedule)JSONObject.toBean((JSONObject)jSONObject, RebootSchedule.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)rebootSchedule);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        operationResponse = this.b((Schedule)rebootSchedule);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        return this.addSchedule((Schedule)rebootSchedule);
    }

    @Override
    public OperationResponse modifyRebootSchedule(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        RebootSchedule rebootSchedule = (RebootSchedule)JSONObject.toBean((JSONObject)jSONObject, RebootSchedule.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)rebootSchedule);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        operationResponse = this.b((Schedule)rebootSchedule);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        return this.refreshSchedule((Schedule)rebootSchedule);
    }

    @Override
    public OperationResponse getAutoBackupSetting(ControlType controlType, JSONObject reqObj) {
        ScheduleTime scheduleTime;
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)this.a.findByScheduleType(TaskType.AutoBackup.name());
        if (null == autoBackupSchedule) {
            autoBackupSchedule = new AutoBackupSchedule();
            autoBackupSchedule.setSite("Default");
            autoBackupSchedule.setEnable(false);
            autoBackupSchedule.setScheduleType(TaskType.AutoBackup.name());
            autoBackupSchedule.setMaxNoOfFiles(Integer.valueOf(7));
            scheduleTime = new ScheduleTime();
            scheduleTime.setStartTime(new HMS(0, 0, 0));
            autoBackupSchedule.setScheduleTime(scheduleTime);
        }
        if (!l.b()) {
            scheduleTime = this.c.getAvailablePaths();
            if (CollectionUtils.isEmpty(scheduleTime) && autoBackupSchedule.isEnable()) {
                autoBackupSchedule.setEnable(false);
                this.refreshSchedule((Schedule)autoBackupSchedule);
            }
            autoBackupSchedule.setAvailablePaths(scheduleTime);
        }
        return new OperationResponse(ResErrorCode.a, (Object)autoBackupSchedule);
    }

    @Override
    public OperationResponse modifyAutoBackupSchedule(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (null == jSONObject) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)JSONObject.toBean((JSONObject)jSONObject, AutoBackupSchedule.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)autoBackupSchedule);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (autoBackupSchedule.isEnable()) {
            operationResponse = this.a(autoBackupSchedule.getScheduleTime());
            if (!operationResponse.success()) {
                return operationResponse;
            }
            if (null == autoBackupSchedule.getMaxNoOfFiles() || autoBackupSchedule.getMaxNoOfFiles() < 1 || autoBackupSchedule.getMaxNoOfFiles() > 50) {
                return new OperationResponse(ResErrorCode.bH);
            }
        }
        if (null == this.a.findByScheduleType(TaskType.AutoBackup.name())) {
            d.debug("A new auto backup schedule");
            String string = jSONObject.optString("savingPath");
            d.debug(string);
            if (StringUtils.isEmpty((Object)string)) {
                if (l.b()) {
                    Configuration configuration = com.tp_link.eap.configuration.a.a((String)"eap.properties");
                    if (configuration == null) {
                        return new OperationResponse(ResErrorCode.f);
                    }
                    autoBackupSchedule.setSavingPath(configuration.getProperty("eap.autobackup.path"));
                } else if (autoBackupSchedule.isEnable()) {
                    return new OperationResponse(ResErrorCode.eQ);
                }
            } else if (!l.b()) {
                this.c.createDirectory(this.c.getAutoBackupFileSavingPath(string));
                autoBackupSchedule.setSavingPath(string);
            }
            if (null == autoBackupSchedule.getScheduleType()) {
                autoBackupSchedule.setScheduleType(TaskType.AutoBackup.name());
            }
            return this.addSchedule((Schedule)autoBackupSchedule);
        }
        if (l.b()) {
            AutoBackupSchedule autoBackupSchedule2 = (AutoBackupSchedule)this.getSchedule(autoBackupSchedule.getScheduleId());
            autoBackupSchedule.setSavingPath(autoBackupSchedule2.getSavingPath());
        } else if (autoBackupSchedule.isEnable()) {
            String string = jSONObject.optString("savingPath");
            if (StringUtils.isEmpty((Object)string) || CollectionUtils.isEmpty(this.c.getAvailablePaths())) {
                return new OperationResponse(ResErrorCode.eQ);
            }
            this.c.createDirectory(this.c.getAutoBackupFileSavingPath(string));
            autoBackupSchedule.setSavingPath(string);
        }
        return this.refreshSchedule((Schedule)autoBackupSchedule);
    }

    @Override
    public OperationResponse getGridSchedules(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("scheduleId");
            queryData.setSortOrder("asc");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"scheduleName"});
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getScheduleTypeList(ControlType controlType, JSONObject reqObj) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TaskType[] taskTypeArray = TaskType.values();
        if (taskTypeArray != null && taskTypeArray.length > 0) {
            for (TaskType taskType : taskTypeArray) {
                arrayList.add(taskType.name());
            }
        }
        TaskType[] taskTypeArray2 = new HashMap();
        taskTypeArray2.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)taskTypeArray2);
    }

    private OperationResponse b(Schedule schedule) {
        boolean bl = false;
        ScheduleTime scheduleTime = schedule.getScheduleTime();
        if (scheduleTime.getTimingType().equals((Object)TimingType.Weekly)) {
            if (scheduleTime.isMon()) {
                bl = true;
            }
            if (scheduleTime.isTues()) {
                bl = true;
            }
            if (scheduleTime.isWen()) {
                bl = true;
            }
            if (scheduleTime.isThurs()) {
                bl = true;
            }
            if (scheduleTime.isFri()) {
                bl = true;
            }
            if (scheduleTime.isSat()) {
                bl = true;
            }
            if (scheduleTime.isSun()) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.ax);
    }

    private OperationResponse a(ScheduleTime scheduleTime) {
        TimingType timingType = scheduleTime.getTimingType();
        switch (timingType) {
            case Hourly: {
                return com.tp_link.eap.util.e.bd;
            }
            case Daily: {
                return com.tp_link.eap.util.e.bd;
            }
            case Weekly: {
                if (scheduleTime.isMon() || scheduleTime.isTues() || scheduleTime.isWen() || scheduleTime.isThurs() || scheduleTime.isFri() || scheduleTime.isSat() || scheduleTime.isSun()) {
                    return com.tp_link.eap.util.e.bd;
                }
                return new OperationResponse(ResErrorCode.ax);
            }
            case Monthly: {
                if (scheduleTime.getDayOfMonth() > 0 && scheduleTime.getDayOfMonth() < 32) {
                    return com.tp_link.eap.util.e.bd;
                }
                return new OperationResponse(ResErrorCode.bF);
            }
            case Yearly: {
                if (scheduleTime.getDayOfMonth() > 0 && scheduleTime.getDayOfMonth() < 32 && scheduleTime.getMonthOfYear() > 0 && scheduleTime.getMonthOfYear() < 13) {
                    return com.tp_link.eap.util.e.bd;
                }
                return new OperationResponse(ResErrorCode.bG);
            }
        }
        return new OperationResponse(ResErrorCode.d);
    }

    private Schedule a() {
        String string = com.tp_link.eap.d.b.a();
        Schedule schedule = this.a.findByScheduleTypeAndSite(TaskType.Reboot.name(), string);
        if (schedule == null) {
            RebootSchedule rebootSchedule = new RebootSchedule();
            rebootSchedule.setSite(string);
            rebootSchedule.setEnable(false);
            ScheduleTime scheduleTime = new ScheduleTime();
            scheduleTime.setTimingType(TimingType.Daily);
            scheduleTime.setStartTime(new HMS(0, 0, 0));
            rebootSchedule.setScheduleTime(scheduleTime);
            rebootSchedule.setScheduleType(TaskType.Reboot.name());
            rebootSchedule.setScheduleCron(com.tp_link.eap.monitor.task.b.a.a(scheduleTime));
            rebootSchedule.setNextExecute(com.tp_link.eap.monitor.task.b.a.b(rebootSchedule.getScheduleTime()));
            schedule = (Schedule)this.a.save(rebootSchedule);
        }
        return schedule;
    }
}

